<?php $__env->startSection('styles'); ?>

    <!--  BEGIN CUSTOM STYLE FILE  -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/src/apex/apexcharts.css')); ?>">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/light/plugins/apex/custom-apexcharts.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/dark/plugins/apex/custom-apexcharts.scss']); ?>
    <!--  END CUSTOM STYLE FILE  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="navSection" data-bs-spy="affix" class="nav sidenav">
    <div class="sidenav-content">
        <a href="#chartLine" class="active nav-link">Line</a>
        <a href="#chartArea" class="nav-link">Area</a>
        <a href="#chartColumn" class="nav-link">Column</a>
        <a href="#chartColumnStacked" class="nav-link">Column Stacked</a>
        <a href="#chartBar" class="nav-link">Bar</a>
        <a href="#chartMixed" class="nav-link">Mixed</a>
        <a href="#chartDonut" class="nav-link">Donut</a>
        <a href="#chartRadial" class="nav-link">Radial</a>
    </div>
</div>

<div class="row" id="cancel-row">
    <div id="chartLine" class="col-xl-12 layout-top-spacing layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Apex (Simple)</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="s-line" class=""></div>

                <div class="code-section-container show-code">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var sline = {
chart: {
height: 350,
type: 'line',
zoom: {
enabled: false
},
toolbar: {
show: false,
}
},
dataLabels: {
enabled: false
},
stroke: {
curve: 'straight'
},
series: [{
name: "Desktops",
data: [10, 41, 35, 51, 49, 62, 69, 91, 148]
}],
title: {
text: 'Product Trends by Month',
align: 'left'
},
grid: {
row: {
colors: ['#f1f2f3', 'transparent'], // takes an array which will be repeated on columns
opacity: 0.5
},
},
xaxis: {
categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep'],
}
}

var chart = new ApexCharts(
document.querySelector("#s-line"),
sline
);

chart.render();</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chartArea" class="col-xl-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Simple Area</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="s-line-area" class=""></div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var sLineArea = {
chart: {
height: 350,
type: 'area',
toolbar: {
show: false,
}
},
dataLabels: {
enabled: false
},
stroke: {
curve: 'smooth'
},
series: [{
name: 'series1',
data: [31, 40, 28, 51, 42, 109, 100]
}, {
name: 'series2',
data: [11, 32, 45, 32, 34, 52, 41]
}],

xaxis: {
type: 'datetime',
categories: ["2018-09-19T00:00:00", "2018-09-19T01:30:00", "2018-09-19T02:30:00", "2018-09-19T03:30:00", "2018-09-19T04:30:00", "2018-09-19T05:30:00", "2018-09-19T06:30:00"],                
},
tooltip: {
x: {
format: 'dd/MM/yy HH:mm'
},
}
}

var chart = new ApexCharts(
document.querySelector("#s-line-area"),
sLineArea
);

chart.render();</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chartColumn" class="col-xl-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Simple Column</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="s-col" class=""></div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var sCol = {
chart: {
height: 350,
type: 'bar',
toolbar: {
show: false,
}
},
plotOptions: {
bar: {
horizontal: false,
columnWidth: '55%',
endingShape: 'rounded'  
},
},
dataLabels: {
enabled: false
},
stroke: {
show: true,
width: 2,
colors: ['transparent']
},
series: [{
name: 'Net Profit',
data: [44, 55, 57, 56, 61, 58, 63, 60, 66]
}, {
name: 'Revenue',
data: [76, 85, 101, 98, 87, 105, 91, 114, 94]
}],
xaxis: {
categories: ['Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
},
yaxis: {
title: {
text: '$ (thousands)'
}
},
fill: {
opacity: 1

},
tooltip: {
y: {
formatter: function (val) {
return "$ " + val + " thousands"
}
}
}
}

var chart = new ApexCharts(
document.querySelector("#s-col"),
sCol
);

chart.render();
</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chartColumnStacked" class="col-xl-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Simple Column Stacked</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="s-col-stacked" class=""></div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var sColStacked = {
chart: {
height: 350,
type: 'bar',
stacked: true,
toolbar: {
show: false,
}
},
responsive: [{
breakpoint: 480,
options: {
legend: {
position: 'bottom',
offsetX: -10,
offsetY: 0
}
}
}],
plotOptions: {
bar: {
horizontal: false,
},
},
series: [{
name: 'PRODUCT A',
data: [44, 55, 41, 67, 22, 43]
},{
name: 'PRODUCT B',
data: [13, 23, 20, 8, 13, 27]
},{
name: 'PRODUCT C',
data: [11, 17, 15, 15, 21, 14]
},{
name: 'PRODUCT D',
data: [21, 7, 25, 13, 22, 8]
}],
xaxis: {
type: 'datetime',
categories: ['01/01/2011 GMT', '01/02/2011 GMT', '01/03/2011 GMT', '01/04/2011 GMT', '01/05/2011 GMT', '01/06/2011 GMT'],
},
legend: {
position: 'right',
offsetY: 40
},
fill: {
opacity: 1
},
}

var chart = new ApexCharts(
document.querySelector("#s-col-stacked"),
sColStacked
);

chart.render();</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chartBar" class="col-xl-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Simple Bar</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="s-bar" class=""></div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var sBar = {
chart: {
height: 350,
type: 'bar',
toolbar: {
show: false,
}
},
plotOptions: {
bar: {
horizontal: true,
}
},
dataLabels: {
enabled: false
},
series: [{
data: [400, 430, 448, 470, 540, 580, 690, 1100, 1200, 1380]
}],
xaxis: {
categories: ['South Korea', 'Canada', 'United Kingdom', 'Netherlands', 'Italy', 'France', 'Japan', 'United States', 'China', 'Germany'],
}
}

var chart = new ApexCharts(
document.querySelector("#s-bar"),
sBar
);

chart.render();</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chartMixed" class="col-xl-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Mixed</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="mixed-chart" class=""></div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var options = {
chart: {
height: 350,
type: 'line',
toolbar: {
show: false,
}
},
series: [{
name: 'Website Blog',
type: 'column',
data: [440, 505, 414, 671, 227, 413, 201, 352, 752, 320, 257, 160]
}, {
name: 'Social Media',
type: 'line',
data: [23, 42, 35, 27, 43, 22, 17, 31, 22, 22, 12, 16]
}],
stroke: {
width: [0, 4]
},
title: {
text: 'Traffic Sources'
},
labels: ['01 Jan 2001', '02 Jan 2001', '03 Jan 2001', '04 Jan 2001', '05 Jan 2001', '06 Jan 2001', '07 Jan 2001', '08 Jan 2001', '09 Jan 2001', '10 Jan 2001', '11 Jan 2001', '12 Jan 2001'],
xaxis: {
type: 'datetime'
},
yaxis: [{
title: {
text: 'Website Blog',
},

}, {
opposite: true,
title: {
text: 'Social Media'
}
}]

}

var chart = new ApexCharts(
document.querySelector("#mixed-chart"),
options
);

chart.render();</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chartDonut" class="col-xl-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Donut</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="donut-chart" class=""></div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var donutChart = {
chart: {
height: 350,
type: 'donut',
toolbar: {
show: false,
}
},
series: [44, 55, 41, 17],
responsive: [{
breakpoint: 480,
options: {
chart: {
width: 200
},
legend: {
position: 'bottom'
}
}
}]
}

var donut = new ApexCharts(
document.querySelector("#donut-chart"),
donutChart
);

donut.render();</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chartRadial" class="col-xl-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Radial</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <div id="radial-chart" class=""></div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                            <pre>
var radialChart = {
chart: {
height: 350,
type: 'radialBar',
toolbar: {
show: false,
}
},
plotOptions: {
radialBar: {
dataLabels: {
name: {
fontSize: '22px',
},
value: {
fontSize: '16px',
},
total: {
show: true,
label: 'Total',
formatter: function (w) {
    // By default this function returns the average of all series. The below is just an example to show the use of custom formatter function
    return 249
}
}
}
}
},
series: [44, 55, 67, 83],
labels: ['Apples', 'Oranges', 'Bananas', 'Berries'],    
}

var chart = new ApexCharts(
document.querySelector("#radial-chart"),
radialChart
);

chart.render();</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script src="<?php echo e(asset('plugins/src/apex/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/src/apex/custom-apexcharts.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Work Station\cork-v4.0.0\laravel\vertical-light-menu\resources\views/admin/charts.blade.php ENDPATH**/ ?>